/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CoalGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class NetheriteGolem
extends BaseGolem
implements IShearable,
PlayerRideableJumping {
    public static final byte SUMMON_EVENT_ID = 8;
    public static final int SUMMON_TICKS_LENGTH = 60;
    public static final int DEATH_TICKS = 50;
    public static final int SUMMONING_COOLDOWN_TICKS_LENGTH = 1200;
    private static final EntityDataAccessor<Boolean> ID_CHARGED = SynchedEntityData.defineId(NetheriteGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ID_GILDED = SynchedEntityData.defineId(NetheriteGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int summoningTicks;
    private int summonCooldown;
    private int lastJumpPower;

    public NetheriteGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 24;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 320.0).add(Attributes.ARMOR, 20.0).add(Attributes.ARMOR_TOUGHNESS, 8.0).add(Attributes.MOVEMENT_SPEED, 0.14).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.STEP_HEIGHT, 1.5);
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        GolemConstructionRecipe recipe = (GolemConstructionRecipe)((RecipeHolder)level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get(), (RecipeInput)new SingleEntityInput((EntityType)ModEntityTypes.NETHERITE_GOLEM.get()), level).orElseThrow()).value();
        BlockPattern.BlockPatternMatch pattern = recipe.createPattern().find((LevelReader)level, pos);
        if (pattern == null) {
            return;
        }
        NetheriteGolem golem = (NetheriteGolem)((EntityType)ModEntityTypes.NETHERITE_GOLEM.get()).create(level);
        if (golem == null) {
            return;
        }
        ModUtils.spawnGolemInWorld(level, pattern, (Entity)golem, pattern.getBlock(1, 2, 0).getPos());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.getMovementController());
        controllers.add(new AnimationController((GeoAnimatable)this, "attack_controller", 0, state -> {
            if (!this.hasAttackAnimation()) {
                return PlayState.STOP;
            }
            if (this.attackAnimationTicks == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return this.getAttackAnimation((AnimationState<? extends BaseGolem>)state);
        }).setSoundKeyframeHandler(event -> this.level().playLocalSound(this.blockPosition(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_HIT.get(), this.getSoundSource(), 1.0f, 1.0f, false)));
        controllers.add(new AnimationController((GeoAnimatable)this, "death_controller", 0, state -> {
            if (this.deathTime == 0) {
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.DIE);
        }).setSoundKeyframeHandler(event -> this.level().playLocalSound(this.blockPosition(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_DEATH.get(), this.getSoundSource(), 1.0f, 1.0f, false)));
        controllers.add(new AnimationController((GeoAnimatable)this, "summon_controller", 0, state -> {
            if (this.getSummoningTicks() == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.SUMMON);
        }).setSoundKeyframeHandler(event -> this.level().playLocalSound(this.blockPosition(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_SUMMON.get(), this.getSoundSource(), 1.0f, 1.0f, false)));
    }

    @Override
    public AnimationController<?> getMovementController() {
        return super.getMovementController().setSoundKeyframeHandler(event -> this.level().playLocalSound(this.blockPosition(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_STEP.get(), this.getSoundSource(), 1.0f, 1.0f, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_CHARGED, (Object)false);
        builder.define(ID_GILDED, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("charged", this.isCharged());
        compound.putBoolean("gilded", this.isGilded());
        compound.putInt("summoning_ticks", this.getSummoningTicks());
        compound.putInt("summon_cooldown", this.getSummonCooldown());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCharged(compound.getBoolean("charged"));
        this.setGilded(compound.getBoolean("gilded"));
        this.setSummoningTicks(compound.getInt("summoning_ticks"));
        this.setSummonCooldown(compound.getInt("summon_cooldown"));
    }

    public boolean isCharged() {
        return (Boolean)this.entityData.get(ID_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.entityData.set(ID_CHARGED, (Object)charged);
    }

    public boolean isGilded() {
        return (Boolean)this.entityData.get(ID_GILDED);
    }

    public void setGilded(boolean gilded) {
        this.entityData.set(ID_GILDED, (Object)gilded);
    }

    public int getSummoningTicks() {
        return this.summoningTicks;
    }

    public void setSummoningTicks(int summoningTicks) {
        this.summoningTicks = summoningTicks;
    }

    public int getSummonCooldown() {
        return this.summonCooldown;
    }

    public void setSummonCooldown(int summonCooldown) {
        this.summonCooldown = summonCooldown;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Override
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 8) {
            this.summoningTicks = 60;
        }
    }

    protected boolean isAffectedByFluids() {
        return false;
    }

    protected float getWaterSlowDown() {
        return 0.0f;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.INDIRECT_MAGIC)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean isSensitiveToWater() {
        return this.isCharged();
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return ((MobEffect)effectInstance.getEffect().value()).isBeneficial();
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 50 && !this.level().isClientSide() && !this.isRemoved()) {
            this.removeAndAddDeathParticles();
        }
    }

    @Override
    public boolean canFloatInWater() {
        return false;
    }

    @Override
    public boolean hasAttackAnimation() {
        return this.getSummoningTicks() == 0;
    }

    @Override
    public int getAttackTicks() {
        return 25;
    }

    @Override
    public int getAttackDelayTicks() {
        return 14;
    }

    @Override
    public Item getRepairItem() {
        return Items.NETHERITE_SCRAP;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 80.0f;
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (super.mobInteract(player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (this.isCharged()) {
            if (stack.is(Items.BUCKET)) {
                this.setCharged(false);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.is(Items.LAVA_BUCKET)) {
            if (!player.getAbilities().instabuild) {
                player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
            }
            this.playSound(SoundEvents.BUCKET_EMPTY_LAVA);
            this.setCharged(true);
            return InteractionResult.SUCCESS;
        }
        if (!this.isGilded() && stack.is(Items.GOLD_INGOT)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value());
            this.setGilded(true);
            return InteractionResult.SUCCESS;
        }
        if (stack.is(Items.SHEARS)) {
            return InteractionResult.PASS;
        }
        if (player.getVehicle() == null) {
            player.setYRot(this.getYRot());
            player.setXRot(this.getXRot());
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        this.playSound(SoundEvents.SNOW_GOLEM_SHEAR);
        this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value());
        this.setGilded(false);
        return List.of(Items.GOLD_INGOT.getDefaultInstance());
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return this.isGilded();
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(1.0, 0.0, 1.0);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)passenger;
            entity.yBodyRot = this.yBodyRot;
        }
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.setRot(vec2.y, vec2.x);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.getXRot() * 0.5f, entity.getYRot());
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        float x = player.xxa * 0.25f;
        float z = player.zza;
        if (z <= 0.0f) {
            z *= 0.25f;
        }
        return new Vec3((double)x, 0.0, (double)z);
    }

    protected float getRiddenSpeed(Player player) {
        if (this.getSummoningTicks() > 0) {
            return 0.0f;
        }
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.45f;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (!this.isNoAi() && (entity = this.getFirstPassenger()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2;
        }
        return null;
    }

    public void onPlayerJump(int jumpPower) {
    }

    public boolean canJump() {
        return !this.isAttacking();
    }

    public void handleStartJump(int jumpPower) {
        this.startAttacking();
        this.sendAttackEvent();
        this.lastJumpPower = jumpPower;
    }

    public void handleStopJump() {
    }

    @Override
    public void actuallyAttackAfterDelay(LivingEntity target) {
        if (this.lastJumpPower == 0) {
            Vec3 lookAngle = this.getLookAngle();
            target.addDeltaMovement(new Vec3(lookAngle.x * 0.4, 0.5, lookAngle.z * 0.4));
            super.actuallyAttackAfterDelay(target);
        }
    }

    @Override
    public void performAdditionalAttacks(@Nullable LivingEntity target) {
        if (this.lastJumpPower > 0) {
            int attackBonus = this.lastJumpPower;
            int rangeBonus = this.lastJumpPower;
            float y = 0.5f;
            if (this.lastJumpPower == 100) {
                attackBonus = 175;
                rangeBonus = 150;
                y = 0.75f;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    Vec3 lookAngle = this.getLookAngle();
                    ModUtils.sendParticles(level2, ParticleTypes.EXPLOSION, this.getX() + lookAngle.x * 0.5, this.getY() + 0.5, this.getZ() + lookAngle.z * 0.5, 10, 0.5, 0.5, 0.5, 0.0);
                }
            }
            this.doAoeAttack(null, 4.0f + (float)attackBonus / 6.0f, 1.5f + (float)rangeBonus / 40.0f, y);
            this.lastJumpPower = 0;
        } else {
            this.doAoeAttack(target, (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE), 0.5f, 0.5f);
        }
    }

    public void doAoeAttack(@Nullable LivingEntity target, float damage, float radius, float y) {
        for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)radius))) {
            if (entity == this || target != null && entity instanceof AbstractGolem || target != null && entity instanceof Player || target != null && entity instanceof OwnableEntity || entity.equals((Object)this.getFirstPassenger())) continue;
            entity.hurt(this.damageSources().mobAttack((LivingEntity)this), damage);
            Vec3 lookAngle = this.getLookAngle();
            entity.addDeltaMovement(new Vec3(lookAngle.x * 0.4, (double)y, lookAngle.z * 0.4));
        }
    }

    public boolean canAttack(LivingEntity target) {
        return !this.isVehicle();
    }

    @Override
    public void aiStep() {
        this.summoningTicks = Math.max(0, this.summoningTicks - 1);
        this.summonCooldown = Math.max(0, this.summonCooldown - 1);
        if (!this.level().isClientSide()) {
            if (this.summoningTicks > 0) {
                if (this.summoningTicks == 40) {
                    this.spawnCoalGolems();
                }
                this.navigation.stop();
                this.setTarget(null);
            }
            if (!this.isAttacking() && this.summonCooldown == 0 && this.getTarget() != null && this.getFirstPassenger() == null && this.random.nextInt(100) == 0) {
                this.summon();
            }
        }
        if (this.level().isClientSide() && this.isCharged()) {
            this.spawnFireParticles();
        }
        super.aiStep();
    }

    private void spawnFireParticles() {
        Vec3 lookAngle = this.getLookAngle();
        this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.3) + lookAngle.x * 0.5, this.getY() + 0.8, this.getRandomZ(0.3) + lookAngle.z * 0.5, lookAngle.x * 0.05, 0.05, lookAngle.z * 0.05);
    }

    public void summon() {
        if (this.summonCooldown > 0) {
            return;
        }
        if (!this.isCharged()) {
            return;
        }
        this.summoningTicks = 60;
        this.summonCooldown = 1200;
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
    }

    public void spawnCoalGolems() {
        int i;
        this.playSound(SoundEvents.FIRECHARGE_USE);
        for (i = 0; i < 5; ++i) {
            CoalGolem golem = (CoalGolem)((EntityType)ModEntityTypes.COAL_GOLEM.get()).create(this.level());
            if (golem == null) {
                return;
            }
            Vec3 lookAngle = this.getLookAngle();
            golem.setPos(this.getX() + lookAngle.x * 0.5, this.getY() + 0.35, this.getZ() + lookAngle.z * 0.5);
            golem.setLit(true);
            golem.setSummoner(this.getUUID());
            this.level().addFreshEntity((Entity)golem);
            golem.setTarget(this.getTarget());
            golem.setTarget(this.getTarget());
        }
        for (i = 0; i < 10; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY() - 0.75, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 0.5, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 0.5);
        }
    }
}

